
`--------------
` Apply Texture
`--------------
function ApplyTexture(iObject as integer,iFolder as string)
   if TexturesEnabled=0
      global TexturesEnabled as integer : TexturesEnabled=1
      global TexturesCount as integer : TexturesCount=-1
      global dim Textures[] as integer
      global dim TexturesFile[] as string
      global dim TexturesFind[255,16000] as integer
      global dim TexturesFindCount[255] as integer
   endif
   local tTextureFile as string
   local tTextureName as string
   local tExtension as string
   for m=1 to GetObjectNumtextures(iObject)
     if m<GetObjectNumMeshes(iObject)+1
        tTextureFile=GetObjectTextureName(iObject,m)
        tTextureName=left(tTextureFile,len(tTextureFile)-3)
        tExtension=lower(right(tTextureFile,3))
        tFormatSupport=0
        if tExtension="png" or tExtension="bmp" or tExtension="jpg" then tFormatSupport=1
        if tFormatSupport=0 or GetFileExists(tTextureFile)=0
           if GetFileExists(tTextureName+".jpg")=1 then tTextureFile=tTextureName+"jpg"
           if GetFileExists(tTextureName+".bmp")=1 then tTextureFile=tTextureName+"bmp"
           if GetFileExists(tTextureName+".png")=1 then tTextureFile=tTextureName+"png"
        endif
        if GetFileExists(tTextureFile)=0
           x=len(tTextureName)
           for t=1 to x
              if mid(tTextureName,x-(t-1),1)="\" or mid(tTextureName,x-(t-1),1)="/" then exit
           next t
           tTextureName=right(tTextureName,t)
           if GetFileExists(iFolder+"\"+tTextureName+"jpg")=1 then tTextureFile=iFolder+"\"+tTextureName+"jpg"
           if GetFileExists(iFolder+"\"+tTextureName+"bmp")=1 then tTextureFile=iFolder+"\"+tTextureName+"bmp"
           if GetFileExists(iFolder+"\"+tTextureName+"png")=1 then tTextureFile=iFolder+"\"+tTextureName+"png"
        endif
        if GetFileExists(tTextureFile)=1
           tExtension=lower(right(tTextureFile,3))
           tImage=LoadTextureTable(tTextureFile)
           SetObjectMeshImage(iObject,m,tImage,0)
           if GetFileExists(left(tTextureFile,len(tTextureFile)-4)+"_n."+tExtension)=1 
              tImage=LoadTextureTable(left(tTextureFile,len(tTextureFile)-4)+"_n."+tExtension)
              SetObjectMeshImage(iObject,m,tImage,1)
           endif
           if GetFileExists(left(tTextureFile,len(tTextureFile)-4)+"_s."+tExtension)=1 
              tImage=LoadTextureTable(left(tTextureFile,len(tTextureFile)-4)+"_s."+tExtension)
              SetObjectMeshImage(iObject,m,tImage,2)
           endif
        endif
      endif
   next m 
endfunction 

`--------------
` Load Texture
`--------------
function LoadTextureTable(iFile as string)
   local tName as string
   iFile=lower(iFile)
   x=len(iFile)
   for t=1 to x
       if mid(iFile,x-(t-1),1)="\" or mid(iFile,x-(t-1),1)="/" then exit
   next t
   tName=right(iFile,t)
   tAsc=asc(tName)
   rImage=0
   for t=0 to TexturesFindCount[tAsc]-1
      tTexture=TexturesFind[tAsc,t]
      if TexturesFile[tTexture]=tName
         rImage=Textures[tTexture]
         exitfunction rImage
      endif
   next t
   if GetFileExists(iFile)=1
      inc TexturesCount
      Textures.length=Textures.length+1
      TexturesFile.length=TexturesFile.length+1
      Textures[TexturesCount]=FreeUpImage(32500+random(0,32500))
      TexturesFile[TexturesCount]=tName
      LoadTexture(Textures[TexturesCount],iFile)
      rImage=Textures[TexturesCount]
      TexturesFind[tAsc,TexturesFindCount[tAsc]]=TexturesCount
      inc TexturesFindCount[tAsc]
   endif
endfunction rImage

`--------------
` Clear Textures
`--------------
function ClearTexture()
   if TexturesEnabled=0
      for t=0 to TexturesCount
         tTexture=Textures[t]
         if GetImageExists(tTexture)=1 then DeleteImage(tTexture)
      next t
      undim Textures[]
      undim TexturesFile[]
      undim TexturesFindCount[]
      TexturesCount=-1
      global dim Textures[] as integer
      global dim TexturesFile[] as string
      global dim TexturesFindCount[255] as integer
   endif
endfunction

`Entities data
type Map_EntitiesData
   Class as string
   KeyValueStart as integer
   KeyValueEnd as integer
   Position as Vec3Float
endtype

`Key Value
type Map_EntityKeyValueData
   Key as string
   value as string
endtype

`--------------
` Load Map Entities
`--------------
function MapLoadEntities(iFile as string)

   `Read entities file
      if GetFileExists(iFile)=1
         local tStr as string
         global Map_EntitiesEnabled as integer
         global Map_EntitiesCount as integer
         global Map_EntityKeyValueCount as integer
         global dim Map_Entities[] as Map_EntitiesData
         global dim Map_EntityKeyValue[] as Map_EntityKeyValueData
         Map_EntitiesEnabled=1
         Map_EntitiesCount=-1
         Map_EntityKeyValueCount=-1
         tFile=OpenToRead(iFile)
         repeat
            tStr=ReadLine(tFile)
            inc Map_EntitiesCount
            Map_Entities.length=Map_Entities.length+1
            Map_Entities[Map_EntitiesCount].Class=left(tStr,len(tStr)-1)
            Map_Entities[Map_EntitiesCount].KeyValueStart=Map_EntityKeyValueCount+1
            tStr=ReadLine(tFile)
            repeat
               tStr=ReadLine(tFile)
               inc Map_EntityKeyValueCount
               Map_EntityKeyValue.length=Map_EntityKeyValue.length+1
               tMid=1
               repeat
                  inc tMid
               until mid(tStr,tMid,1)=":" or mid(tStr,tMid,1)=""
               Map_EntityKeyValue[Map_EntityKeyValueCount].Key=left(tStr,tMid-1)
               Map_EntityKeyValue[Map_EntityKeyValueCount].value=Right(tStr,len(tStr)-tMid)
            until tStr="};" or tStr="" or FileEOF(tFile)=1
            Map_Entities[Map_EntitiesCount].KeyValueEnd=Map_EntityKeyValueCount
            Map_Entities[Map_EntitiesCount].Position.x=Map_GetEntityParameter(Map_EntitiesCount,0,0)
            Map_Entities[Map_EntitiesCount].Position.y=Map_GetEntityParameter(Map_EntitiesCount,0,1)
            Map_Entities[Map_EntitiesCount].Position.z=Map_GetEntityParameter(Map_EntitiesCount,0,2)
         until tStr="" or FileEOF(tFile)=1
         CloseFile(tFile)

      `Create Lights
         if Map_LightsCount>0
            for l=0 to Map_LightsCount-1
               RemoveLight(Map_Lights[l])
            next l
         endif
         global Map_LightsCount as integer
         global dim Map_Lights[] as integer
         Map_LightsCount=0
         for e=0 to MapGetEntitiesCount()
            if MapGetEntityClass(e)="PointLight"
               Map_Lights.length=Map_Lights.length+1
               Map_Lights[Map_LightsCount]=AddLight()
               LightSetPosition(Map_Lights[Map_LightsCount],MapGetEntityPositionX(e),MapGetEntityPositionY(e),MapGetEntityPositionZ(e))
               for v=1 to  MapGetEntityKeyValueCount(e)
                  if Map_GetEntityKey(e,v)="Color" then LightSetColor(Map_Lights[Map_LightsCount],Map_GetEntityParameter(e,v,0),Map_GetEntityParameter(e,v,1),Map_GetEntityParameter(e,v,2))
                  if Map_GetEntityKey(e,v)="Range" then LightSetRange(Map_Lights[Map_LightsCount],val(Map_GetEntityValue(e,v)))
               next v
               inc Map_LightsCount
            endif
            if MapGetEntityClass(e)="SpotLight"
               Map_Lights.length=Map_Lights.length+1
               Map_Lights[Map_LightsCount]=AddLight()
               LightSetPosition(Map_Lights[Map_LightsCount],MapGetEntityPositionX(e),MapGetEntityPositionY(e),MapGetEntityPositionZ(e))
               for v=1 to  MapGetEntityKeyValueCount(e)
                  if Map_GetEntityKey(e,v)="Color" then LightSetColor(Map_Lights[Map_LightsCount],Map_GetEntityParameter(e,v,0),Map_GetEntityParameter(e,v,1),Map_GetEntityParameter(e,v,2))
                  if Map_GetEntityKey(e,v)="Range" then LightSetRange(Map_Lights[Map_LightsCount],val(Map_GetEntityValue(e,v)))
                  if Map_GetEntityKey(e,v)="Angle" then LightSetAngle(Map_Lights[Map_LightsCount],Map_GetEntityParameter(e,v,0),Map_GetEntityParameter(e,v,1),Map_GetEntityParameter(e,v,2),Lighting_Lights[Map_Lights[Map_LightsCount]].Cone.z,Lighting_Lights[Map_Lights[Map_LightsCount]].Cone.w)
                  if Map_GetEntityKey(e,v)="Cone" then LightSetAngle(Map_Lights[Map_LightsCount],Lighting_Lights[Map_Lights[Map_LightsCount]].Angle.x,Lighting_Lights[Map_Lights[Map_LightsCount]].Angle.y,Lighting_Lights[Map_Lights[Map_LightsCount]].Angle.z,val(Map_GetEntityValue(e,v))*0.5,25)
               next v
               inc Map_LightsCount
            endif
            if MapGetEntityClass(e)="DirectionalLight"
               for v=1 to  MapGetEntityKeyValueCount(e)
                  if Map_GetEntityKey(e,v)="Angle" then SkySetSunAngle(Map_GetEntityParameter(e,v,0),Map_GetEntityParameter(e,v,1),Map_GetEntityParameter(e,v,2))
               next v
            endif
         next e

      endif

endfunction

`--------------
` Get Entity Count
`--------------
function MapGetEntitiesCount()
   rCount=Map_EntitiesCount
endfunction rCount

`--------------
` Get Entity class
`--------------
function MapGetEntityClass(iEntity as integer)
   local rClass as string
   if Map_EntitiesEnabled=1
      if iEntity<Map_EntitiesCount+1 then rClass=Map_Entities[iEntity].Class
   endif
endfunction rClass

`--------------
` Get Entity Position X
`--------------
function MapGetEntityPositionX(iEntity as integer)
   local rPos as float
   if Map_EntitiesEnabled=1
      if iEntity<Map_EntitiesCount+1 then rPos=Map_Entities[iEntity].Position.x
   endif
endfunction rPos

`--------------
` Get Entity Position Y
`--------------
function MapGetEntityPositionY(iEntity as integer)
   local rPos as float
   if Map_EntitiesEnabled=1
      if iEntity<Map_EntitiesCount+1 then rPos=Map_Entities[iEntity].Position.y
   endif
endfunction rPos

`--------------
` Get Entity Position Z
`--------------
function MapGetEntityPositionZ(iEntity as integer)
   local rPos as float
   if Map_EntitiesEnabled=1
      if iEntity<Map_EntitiesCount+1 then rPos=Map_Entities[iEntity].Position.z
   endif
endfunction rPos

`--------------
` Get Entity KeyValue Count
`--------------
function  MapGetEntityKeyValueCount(iEntity as integer)
   if Map_EntitiesEnabled=1
      if iEntity<Map_EntitiesCount+1 then rKeyValues=Map_Entities[iEntity].KeyValueEnd-Map_Entities[iEntity].KeyValueStart
   endif
endfunction rKeyValues

`--------------
` Get Entity Key
`--------------
function Map_GetEntityKey(iEntity as integer,iIndex as integer)
   local rKey as string
   if Map_EntitiesEnabled=1
      if iEntity<Map_EntitiesCount+1
         if iIndex<MapGetEntityKeyValueCount(iEntity)+1 then rKey=Map_EntityKeyValue[Map_Entities[iEntity].KeyValueStart+iIndex].Key
      endif
   endif
endfunction rKey

`--------------
` Get Entity Value
`--------------
function Map_GetEntityValue(iEntity,iIndex)
   local rValue as string
   if Map_EntitiesEnabled=1
      if iEntity<Map_EntitiesCount+1
         if iIndex<MapGetEntityKeyValueCount(iEntity)+1 then rValue=Map_EntityKeyValue[Map_Entities[iEntity].KeyValueStart+iIndex].Value
      endif
   endif
endfunction rValue

`--------------
` Get Entity Parameters
`--------------
function Map_GetEntityParameter(iEntity as integer,iIndex as integer,iParameter as integer)
   local rValue as float
   local tStr as string
   if Map_EntitiesEnabled=1
      if iEntity<Map_EntitiesCount+1
        if iIndex< MapGetEntityKeyValueCount(iEntity)+1
            tStr=Map_EntityKeyValue[Map_Entities[iEntity].KeyValueStart+iIndex].Value
            rValue=val(GetStringToken(tStr,",",iParameter+1))
         endif
      endif
   endif
endfunction rValue









